#pragma once

#if SYSTEM_ID==SYSWin_ID
#define OUTSIDE_CALL __stdcall
#else
#define OUTSIDE_CALL
#endif

//Posibles valores de idioma (para los mensajes de error)
#define ATIDIOMA_Esp 0
#define ATIDIOMA_Eng 1
#define ATIDIOMA_It 2

//Unidades de los giros
#define ATUNIGIROS_Rad 0
#define ATUNIGIROS_Gon 1
#define ATUNIGIROS_Sex 2

//Lo que se desea que se haga cuando se pulsa el botón de calcular
#define ATMODOAJUSTE_Completo 0	//Un ajuste normal
#define ATMODOAJUSTE_vvap 1			//Solamente valores aproximados
#define ATMODOAJUSTE_Outputfiles 2	//Sólo ficheros de salida. (No es nec. que los vv. ap. incluyan puntos)
#define ATMODOAJUSTE_Residuos 3		//Además calcular residuos. (Hace falta que haya puntos en los vv. ap.)
#define ATMODOAJUSTE_Simulacion 4	//Se toman los valores aproximados como los valores ajustados y se
													//calcula todo (residuos, precisiones, etc.).

//Modos de tomar / medir las fotografías
#define ATMODOTOMA_Unknown 0
#define ATMODOTOMA_Plano 1
#define ATMODOTOMA_Generico 2
#define ATMODOMEDIDA_Unknown 0
#define ATMODOMEDIDA_Manual 1
#define ATMODOMEDIDA_Automatico 2 //Puede incluir puntos manuales también

/*Códigos de return comunes a todos los programas*/
#define AT_ESC -1
#define AT_NOMEM -2
//Lectura de ficheros
/*El fichero ni siquiera se intenta abrir*/
#define ATREAD_UNKNOWNFORMAT 1	//Se ha pedido leer un fichero de un formato desconocido
/*El fichero se intenta abir pero no se consigue*/
#define ATREAD_NOOPEN_MEM 5	//El fichero no se puede abrir porque no hay memoria suficiente para cargarlo
#define ATREAD_NOOPEN 6			//El fichero no existe o no se ha podido abrir para leer
/*Según la cabecera del fichero (o deducido como sea) el fichero es de una versión que no se puede leer*/
#define ATREAD_NOFORMAT 7		//El fichero no es del tipo que se está esperando leer
#define ATREAD_RECIENTE 8			//La versión del fichero es demasiado reciente
#define ATREAD_MUYANTIGUA 9	//La versión del fichero es tan antigua que no se puede leer
#define ATREAD_ANTIGUA 10			//La versión del fichero es demasiado antigua, pero se puede transformar a la versión actual
/*Errores en el formato. En algún sitio no se ha encontrado lo que se esperaba*/
#define ATREAD_NODATOS 15		//No contiene datos (normalmente se debe a un error en el formato y no a un fichero vacío)
#define ATREAD_BADFORMAT 16	//Otro error en el formato
#define ATREAD_OVERRUN 17		//Algún elemento se extiende o apunta más allá del final del fichero
#define ATREAD_LINEA 18			//final de línea inesperado
#define ATREAD_EOF 19				//final de archivo inesperado (el error anterior salta antes en caso de que el final de línea suponga un error)
#define ATREAD_CARACTER 20	//caracter inválido, de acuerdo a lo que se está esperando, en la palabra que se está leyendo
//
#define ATREAD_MISSINGDATA 21	//Falta algo obligatorio
#define ATREAD_RANGE 22			//valor fuera del conjunto de valores permitido
#define ATREAD_BADKEYVAL	 23		//Nombre de clave o valor de clave no reconocido
#define ATREAD_WRONGPLACE 24	//Se ha encontrado algo en un sitio en el que no está permitido

//Note on fast integer types: u8int, etc.

/*In Aerotri, these types are not for large arrays. Those are built of minimum sizes to save memory,
(but most often there is no saving since they usually are of type uint). These are for small variables
that are usually tested against constants (types of files, idioma, etc.). In any case, the variables for
which these types are used are not very important for the program performance.*/
